package w83b.w83bManager;


import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bDocBeanImpug;
import w83b.w83bBeans.W83bImpugnacionBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;


public class W83bImpugnaciones implements W83bIImpugnaciones {
	public java.util.List buscarImpugnaciones(w83b.w83bBeans.W83bImpugnacionBean param) throws Exception{
		
		
		List listaActas = W83bFactoriaDAO.getImpugnacionesDAO().buscarImpugnaciones(param);
		
		return listaActas;	
	}
	
	public String calcularNumImpugnacion(W83bImpugnacionBean param)throws Exception{		
		String numImpug = W83bFactoriaDAO.getImpugnacionesDAO().calcularNumImpugnacion(param);
		
		return numImpug;	
	}
	
	
	public java.lang.Integer contarImpugnaciones(w83b.w83bBeans.W83bImpugnacionBean param) throws Exception{
		
		return new Integer(W83bFactoriaDAO.getImpugnacionesDAO().contarImpugnaciones(param));	
	}
	public java.util.List cargarCentroTrabajoPreaviso(HashMap mapaResultado) throws Exception{
		List listaDatosParametros = W83bFactoriaDAO.getImpugnacionesDAO().cargarCentroTrabajoPreaviso(mapaResultado);
		
		return listaDatosParametros;
	}
	public java.util.List cargarCentroTrabajoActa(HashMap mapaResultado) throws Exception{
		List listaDatosParametros = W83bFactoriaDAO.getImpugnacionesDAO().cargarCentroTrabajoActa(mapaResultado);
		
		return listaDatosParametros;
	}
	public java.util.List buscarSindicatos(w83b.w83bBeans.W83bImpugnacionBean param) throws Exception{
		List lista = W83bFactoriaDAO.getImpugnacionesDAO().buscarSindicatos(param);
		
		return lista;	
	}

	public W83bImpugnacionBean anyadirImpugnaciones(W83bImpugnacionBean param) throws Exception {
		return W83bFactoriaDAO.getImpugnacionesDAO().anyadirImpugnaciones(param);
		
	}
	
	public void insertarDocsImpugnaciones(W83bImpugnacionBean param) throws Exception {
		W83bFactoriaDAO.getImpugnacionesDAO().insertarDocsImpugnaciones(param);
		
	}
	
	public void anyadirSindicatos(W83bImpugnacionBean param) throws Exception {
		W83bFactoriaDAO.getImpugnacionesDAO().anyadirSindicatos(param);
	}
	public void anyadirEmpresaImpugnante(W83bImpugnacionBean param) throws Exception {
		W83bFactoriaDAO.getImpugnacionesDAO().anyadirEmpresaImpugnante(param);
	}
	public void anyadirTramite(W83bImpugnacionBean param,int fase, int tramite,String fechaRegistro)  throws Exception {
		List lista=(List)param.getListaDocs();
		List iddocs=new ArrayList();
		W83bFactoriaDAO.getImpugnacionesDAO().anyadirTramite(param,fase,tramite,fechaRegistro);
		iddocs.add(String.valueOf(tramite));
		for (int i=0;i<lista.size();i++)
		{
			String t=((W83bDocBeanImpug)lista.get(i)).getCodTramite();
			String f=((W83bDocBeanImpug)lista.get(i)).getCodFase();
			if (!W83bClsConstantes.TRAMITE_SINESPECIFICAR.equals(t)&&!iddocs.contains(t)){
				W83bFactoriaDAO.getImpugnacionesDAO().anyadirTramite(param,Integer.parseInt(f), Integer.parseInt(t),fechaRegistro);
				iddocs.add(String.valueOf(t));
			}
		}
	}
	public void anyadirVoces(W83bImpugnacionBean param) throws Exception {
		W83bFactoriaDAO.getImpugnacionesDAO().anyadirVoces(param);
	}
	public void anyadirLaudo(W83bImpugnacionBean param) throws Exception {
		W83bFactoriaDAO.getImpugnacionesDAO().anyadirLaudo(param);
	}
	
	

	public java.util.List cargaTiposDocumento(HashMap param) throws Exception {
		// TODO Auto-generated method stub
		return W83bFactoriaDAO.getImpugnacionesDAO().cargaTiposDocumento(param);
	}
	public String adjuntarArchivoImpugnaciones(HashMap param) throws Exception {
		 return W83bFactoriaDAO.getImpugnacionesDAO().adjuntarArchivoImpugnaciones(param);
	}
	

	public W83bImpugnacionBean obtenerDetallesImpugnacion(HashMap param)
			throws Exception {
		
		String pestania=(String)param.get("pestania");
		if ("0".equals(pestania))
		{
			//datos basicos
			return W83bFactoriaDAO.getImpugnacionesDAO().obtenerDatosBasicosImpugnacion((String)param.get("codSelec"),(String)param.get("idioma"),(W83bUsuarioXLNetsBean)param.get("Usuario"));

		}
		else
		
				if ("1".equals(pestania))
				{
					//Docs adjuntos
					return W83bFactoriaDAO.getImpugnacionesDAO().obtenerDocsImpugnacion((String)param.get("codSelec"),(String)param.get("idioma"));
				}
				else
					if ("2".equals(pestania))
						{
							if ("1".equals(param.get("grid")))
							{
								//Historial
								return W83bFactoriaDAO.getImpugnacionesDAO().obtenerHistorialImpugnacion((String)param.get("codSelec"),(String)param.get("idioma"));								
							}
							else
							{
								//Tramites
								return W83bFactoriaDAO.getImpugnacionesDAO().obtenerTramitesImpugnacion((String)param.get("codSelec"),(String)param.get("idioma"));
							}

						}
		return null;
	}

	public W83bDocBeanImpug descargarDocumento(String param) throws Exception {

		return W83bFactoriaDAO.getImpugnacionesDAO().descargarDocumento(param);
	}


	public boolean existeImpugnacion(W83bImpugnacionBean param)
			throws Exception {
		return W83bFactoriaDAO.getImpugnacionesDAO().existeImpugnacion(param);
		
	}
	
	public String edicionDocumentosImpugnaciones(W83bImpugnacionBean param) throws Exception {
		W83bClsTrazas.trazaDebug(param.getUsuarioBean(), "W83bImpugnaciones.edicionDocumentosImpugnaciones INICIO");
		
		
		String errorLibroRegistro = "";
		
		String error = W83bFactoriaDAO.getImpugnacionesDAO().insertarDocsImpugnaciones(param);
		if("true".equals(error)){
			errorLibroRegistro = "-3";
		}
		List iddocs=new ArrayList();
		if(null!=param.getListaDocs()){
			
			for (int i=0;i<param.getListaDocs().size();i++){
				W83bDocBeanImpug doc=(W83bDocBeanImpug)param.getListaDocs().get(i);
				if(!W83bClsConstantes.TRAMITE_SINESPECIFICAR.equals(doc.getCodTramite())){
					if(W83bFactoriaDAO.getImpugnacionesDAO().existeTramite(param,Integer.parseInt(doc.getCodFase()),
							Integer.parseInt(doc.getCodTramite()))){
						W83bFactoriaDAO.getImpugnacionesDAO().editarTramite(param, 
								Integer.parseInt(doc.getCodFase()), Integer.parseInt(doc.getCodTramite()));
						iddocs.add(((W83bDocBeanImpug)param.getListaDocs().get(i)).getCodTramite());
					}else{
						if (!iddocs.contains(((W83bDocBeanImpug)param.getListaDocs().get(i)).getCodTramite())){
							W83bFactoriaDAO.getImpugnacionesDAO().anyadirTramite(param,Integer.parseInt(doc.getCodFase()), Integer.parseInt((((W83bDocBeanImpug)param.getListaDocs().get(i)).getCodTramite())),param.getFecha_registro());
							iddocs.add(((W83bDocBeanImpug)param.getListaDocs().get(i)).getCodTramite());
						}
					}
				}
			}
		}
		W83bFactoriaDAO.getImpugnacionesDAO().borrarDocsImpugnaciones(param);
		
		W83bClsTrazas.trazaDebug(param.getUsuarioBean(), "W83bImpugnaciones.edicionDocumentosImpugnaciones FIN");
		return param.getCodSelec()+errorLibroRegistro;
	}
	
	public String edicionImpugnaciones(W83bImpugnacionBean param) throws Exception {
		
		String errorLibroRegistro = "";
		
		W83bFactoriaDAO.getImpugnacionesDAO().editarImpugnaciones(param);
		String error = W83bFactoriaDAO.getImpugnacionesDAO().insertarDocsImpugnaciones(param);
		if("true".equals(error)){
			errorLibroRegistro = "-3";
		}
		List iddocs=new ArrayList();
		if(null!=param.getListaDocs()){
			
			for (int i=0;i<param.getListaDocs().size();i++){
				W83bDocBeanImpug doc=(W83bDocBeanImpug)param.getListaDocs().get(i);
				if(!W83bClsConstantes.TRAMITE_SINESPECIFICAR.equals(doc.getCodTramite())){
					if(W83bFactoriaDAO.getImpugnacionesDAO().existeTramite(param,Integer.parseInt(doc.getCodFase()),
							Integer.parseInt(doc.getCodTramite()))){
						W83bFactoriaDAO.getImpugnacionesDAO().editarTramite(param, 
								Integer.parseInt(doc.getCodFase()), Integer.parseInt(doc.getCodTramite()));
						iddocs.add(((W83bDocBeanImpug)param.getListaDocs().get(i)).getCodTramite());
					}
					else{
						if (!iddocs.contains(((W83bDocBeanImpug)param.getListaDocs().get(i)).getCodTramite())){
							W83bFactoriaDAO.getImpugnacionesDAO().anyadirTramite(param,Integer.parseInt(doc.getCodFase()), Integer.parseInt((((W83bDocBeanImpug)param.getListaDocs().get(i)).getCodTramite())),param.getFecha_registro());
							iddocs.add(((W83bDocBeanImpug)param.getListaDocs().get(i)).getCodTramite());
						}
					}
				}
			}
		}
		W83bFactoriaDAO.getImpugnacionesDAO().borrarDocsImpugnaciones(param);
		W83bFactoriaDAO.getImpugnacionesDAO().borrarVoces(param);
	
		W83bFactoriaDAO.getImpugnacionesDAO().borrarSindicatosImpugnaciones(param);
		//si la impugnaciones es de tipo sindicatos
		if(param.getTipoImpugnacion().equals(String.valueOf(W83bClsConstantes.DOS)))
		{
			//borraremos el impugnante
			W83bFactoriaDAO.getImpugnacionesDAO().borrarImpugnante(param);
		}
		
		
		//si la impugnacion es de tipo empresa 
		if(param.getTipoImpugnacion().equals(String.valueOf(W83bClsConstantes.UNO)))
		{
			W83bFactoriaDAO.getImpugnacionesDAO().editarEmpresaImpugnante(param);
			
		}
		if(W83bFactoriaDAO.getImpugnacionesDAO().tieneLaudoDistinto(param))
		{
		    //borrar trmite laudo
			W83bFactoriaDAO.getImpugnacionesDAO().borrarTramiteLaudo(param.getCodSelec(), (W83bUsuarioXLNetsBean)param.getUsuarioBean());
			W83bFactoriaDAO.getImpugnacionesDAO().borrarLaudo(param.getCodSelec(), (W83bUsuarioXLNetsBean)param.getUsuarioBean());
		}
		if(StringUtils.isNotEmpty(param.getNumLaudo())||StringUtils.isNotEmpty(param.getAnyoLaudo())){
			W83bFactoriaDAO.getImpugnacionesDAO().editarLaudo(param);
		}
		W83bFactoriaDAO.getImpugnacionesDAO().anyadirVoces(param);
		if(param.getTipoImpugnacion().equals(String.valueOf(W83bClsConstantes.DOS)))
		{
			W83bFactoriaDAO.getImpugnacionesDAO().anyadirSindicatos(param);
			
		}
		
		return param.getCodSelec()+errorLibroRegistro;
}
	public String borrarImpugnaciones(List param) throws Exception {
		boolean borrado = true;
		
		W83bUsuarioXLNetsBean userBean = (W83bUsuarioXLNetsBean)param.get(param.size()-1);
		param.remove(param.size()-1);
		
		for(int i=0;i<param.size();i++){
			
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarSindicatos((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarVoces((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarDocsImpugnaciones((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarLaudo((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarEmpresaImpugnante((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarHistorial((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarTramitesImpugnacion((String)param.get(i),userBean);
			borrado =  W83bFactoriaDAO.getImpugnacionesDAO().borrarImpugnacion((String)param.get(i),userBean);
			
			
			if(!borrado){
				break;
			}
		}
		
		if (borrado)
			return "success";
		else 
			throw new Exception();//NOPMD
		
	}
	
	public String existeImpug(HashMap mapaResultado) throws Exception{
		return W83bFactoriaDAO.getImpugnacionesDAO().obtenerNumImpugnacion(mapaResultado);
		
	}
	
   /**
    * Actualiza la informacin de acuse de recibo de comunicaciones de impugnacin resuelta
    * @param listaComunicacionesAcuse List
    * @throws Exception the exception
    * @throws RemoteException the remote exception
    */
	public void  actualizarDatosAcusesComunicacionImpugResueltas(ArrayList listaComunicacionesAcuse) throws Exception{
		//Recorremos las comunicaciones
		for (Iterator iter = listaComunicacionesAcuse.iterator(); iter.hasNext();) {
			W83bDocBean docBean = (W83bDocBean) iter.next();
			docBean.setCodTramite("2");
			docBean.setCodFase("5");
			W83bFactoriaDAO.getImpugnacionesDAO().actualizarDatosAcuseComunicacion(docBean);
		}
	}
	
   /**
    * Actualiza la informacin de acuse de recibo de comunicaciones de laudos resueltos
    * @param listaComunicacionesAcuse List
    * @throws Exception the exception
    * @throws RemoteException the remote exception
    */
	public void  actualizarDatosAcusesComunicacionLaudosResueltos(ArrayList listaComunicacionesAcuse) throws Exception{
		//Recorremos las comunicaciones
		for (Iterator iter = listaComunicacionesAcuse.iterator(); iter.hasNext();) {
			W83bDocBean docBean = (W83bDocBean) iter.next();
			docBean.setCodTramite("5");
			docBean.setCodFase("5");
			W83bFactoriaDAO.getImpugnacionesDAO().actualizarDatosAcuseComunicacion(docBean);
		}
	}
	
	
	public String actualizarVocesLaudo(W83bImpugnacionBean param) throws Exception {
		
		//Borramos las voces anteriores
		W83bFactoriaDAO.getImpugnacionesDAO().borrarVoces(param);
		
		//Aadimos las voces nuevas
		W83bFactoriaDAO.getImpugnacionesDAO().anyadirVoces(param);
		
		return param.getCodSelec();
	}
	

}